/**
 * External dependencies
 */
import { Path, Rect, SVG, SVGProps } from '@wordpress/primitives';

const WordpressSVG = ( props: SVGProps ) => {
	return (
		<SVG
			width="136"
			height="95"
			viewBox="0 0 136 95"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
			role="img"
			{ ...props }
		>
			<Path
				fillRule="evenodd"
				clipRule="evenodd"
				d="M42.9708 18.9005C44.1337 18.134 44.505 16.5837 43.7747 15.3976C43.044 14.2108 41.4873 13.838 40.3216 14.602C30.653 20.9387 22.3008 29.0987 15.7365 38.6338C9.17125 48.1704 4.52929 58.8867 2.061 70.182C1.76407 71.5408 2.66601 72.8592 4.03266 73.1177C5.40037 73.3763 6.7148 72.4749 7.01303 71.1153C11.7833 49.3673 24.9629 30.7687 42.9708 18.9005Z"
				fill="#4DB26A"
			/>
			<Path
				fillRule="evenodd"
				clipRule="evenodd"
				d="M42.9708 18.9005C44.1337 18.134 44.505 16.5837 43.7747 15.3976C43.044 14.2108 41.4873 13.838 40.3216 14.602C30.653 20.9387 22.3008 29.0987 15.7365 38.6338C9.17125 48.1704 4.52929 58.8867 2.061 70.182C1.76407 71.5408 2.66601 72.8592 4.03266 73.1177C5.40037 73.3763 6.7148 72.4749 7.01303 71.1153C11.7833 49.3673 24.9629 30.7687 42.9708 18.9005Z"
				fill="#4DB26A"
			/>
			<Path
				fillRule="evenodd"
				clipRule="evenodd"
				d="M59.5137 42.4168C60.4544 41.8184 60.78 40.5851 60.2172 39.6228C59.654 38.6598 58.4145 38.3328 57.4712 38.9284C46.8358 45.6429 38.5862 55.5676 33.9351 67.2909C29.2835 79.0151 28.4852 91.8974 31.6254 104.078C31.9034 105.156 33.028 105.767 34.0965 105.453C35.1646 105.138 35.7721 104.019 35.4976 102.94C34.382 98.5546 33.7891 93.9608 33.7891 89.2286C33.7891 69.543 44.0492 52.2537 59.5137 42.4168Z"
				fill="#1858D8"
			/>
			<Path
				fillRule="evenodd"
				clipRule="evenodd"
				d="M107.624 32.6581C95.629 28.7574 82.7218 28.7757 70.7641 32.6803C69.7058 33.0259 69.1676 34.1865 69.5489 35.2325C69.9301 36.2785 71.0861 36.8137 72.1454 36.471C77.5265 34.7298 83.2677 33.7891 89.2286 33.7891C107.655 33.7891 123.983 42.7791 134.063 56.6124C134.72 57.514 135.973 57.7612 136.898 57.1381C137.824 56.5147 138.072 55.2561 137.418 54.3517C130.044 44.163 119.618 36.5582 107.624 32.6581Z"
				fill="#272635"
			/>
			<Path
				fillRule="evenodd"
				clipRule="evenodd"
				d="M125.194 10.3266C125.771 9.06103 125.213 7.56393 123.932 7.02306C103.735 -1.50267 81.1004 -2.29366 60.3576 4.8014C59.0419 5.25142 58.3815 6.70568 58.8684 8.00815C59.3554 9.31074 60.805 9.96807 62.1216 9.52038C70.6288 6.62765 79.7479 5.05859 89.2335 5.05859C100.795 5.05859 111.813 7.38976 121.841 11.6077C123.124 12.1471 124.617 11.5926 125.194 10.3266Z"
				fill="#256EFF"
			/>
			<Path
				fillRule="evenodd"
				clipRule="evenodd"
				d="M5.31243 82.6459C5.42004 81.2555 4.42168 80.0104 3.03527 79.8597C1.64766 79.7088 0.396736 80.7112 0.285223 82.1025C-0.050481 86.291 -0.0899009 90.498 0.167258 94.6921C0.252708 96.0857 1.48505 97.1117 2.87569 96.9868C4.26521 96.862 5.28707 95.6354 5.2053 94.2427C5.10795 92.5847 5.05859 90.9139 5.05859 89.2315C5.05859 87.0153 5.14425 84.819 5.31243 82.6459Z"
				fill="#357B49"
			/>
			<Path
				fillRule="evenodd"
				clipRule="evenodd"
				d="M31.7916 50.6255C32.4778 49.6066 32.255 48.2185 31.2581 47.5008C30.2617 46.7836 28.8696 47.0081 28.1828 48.0256C21.8352 57.4297 17.7403 68.1824 16.2306 79.4476C14.7208 90.7147 15.8408 102.168 19.49 112.913C19.8837 114.073 21.1643 114.654 22.3113 114.226C23.4584 113.797 24.0373 112.521 23.6459 111.361C21.3019 104.412 20.0312 96.9691 20.0312 89.2295C20.0312 74.935 24.3656 61.6528 31.7916 50.6255Z"
				fill="#357B49"
			/>
			<Path
				fillRule="evenodd"
				clipRule="evenodd"
				d="M72.5768 17.4851C59.8851 20.4307 48.2153 26.6871 38.7474 35.5993C37.8522 36.4421 37.8544 37.8544 38.7238 38.7238C39.5932 39.5932 41.0003 39.5903 41.8971 38.7492C54.2734 27.1395 70.9211 20.0293 89.2295 20.0293C123.718 20.0293 152.314 45.2605 157.565 78.2712C157.758 79.483 158.867 80.3482 160.084 80.193C161.3 80.038 162.164 78.9257 161.972 77.7148C159.939 64.8699 154.538 52.7777 146.302 42.6792C137.598 32.0067 126.076 23.9885 113.044 19.5351C100.012 15.0817 85.9921 14.3715 72.5768 17.4851Z"
				fill="#357B49"
			/>
			<Rect x="49" y="48" width="82" height="82" rx="41" fill="#1E1E1E" />
			<Path
				fillRule="evenodd"
				clipRule="evenodd"
				d="M121 89C121 71.919 107.081 58 90 58C72.888 58 59 71.919 59 89C59 106.112 72.888 120 90 120C107.081 120 121 106.112 121 89ZM83.118 105.647L72.547 77.282C74.252 77.22 76.174 77.034 76.174 77.034C77.724 76.848 77.538 73.531 75.988 73.593C75.988 73.593 71.493 73.934 68.641 73.934C68.083 73.934 67.494 73.934 66.843 73.903C71.772 66.339 80.297 61.441 90 61.441C97.223 61.441 103.795 64.138 108.755 68.695C106.647 68.354 103.64 69.904 103.64 73.593C103.64 75.6018 104.71 77.3253 105.912 79.2631L105.912 79.2632L105.913 79.2642C106.084 79.539 106.257 79.8181 106.43 80.103C107.515 81.994 108.135 84.319 108.135 87.729C108.135 92.348 103.795 103.229 103.795 103.229L94.402 77.282C96.076 77.22 96.944 76.755 96.944 76.755C98.494 76.6 98.308 72.88 96.758 72.973C96.758 72.973 92.294 73.345 89.38 73.345C86.683 73.345 82.157 72.973 82.157 72.973C80.607 72.88 80.421 76.693 81.971 76.755L84.823 77.003L88.729 87.574L83.118 105.647ZM113.039 88.8199L112.971 89C110.725 94.9133 108.496 100.877 106.271 106.83L106.27 106.832L106.268 106.839L106.261 106.857C105.48 108.947 104.699 111.034 103.919 113.118C112.196 108.344 117.559 99.199 117.559 89C117.559 84.226 116.474 79.824 114.304 75.825C115.237 82.9857 113.804 86.7883 113.039 88.8199ZM77.91 114.079C68.672 109.615 62.441 99.943 62.441 89C62.441 84.97 63.154 81.312 64.673 77.871C65.6006 80.4122 66.5282 82.9547 67.4561 85.498L67.4587 85.5051C70.9333 95.0288 74.412 104.564 77.91 114.079ZM98.401 115.164L90.403 93.526C88.9295 97.8728 87.445 102.22 85.9562 106.58C84.9392 109.558 83.9201 112.542 82.901 115.536C85.133 116.218 87.551 116.559 90 116.559C92.945 116.559 95.735 116.063 98.401 115.164Z"
				fill="white"
			/>
		</SVG>
	);
};

export default WordpressSVG;
