<?php
namespace Skb_Cife;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

/*--------------------------
*   Class Brands Icon Manager
* -------------------------*/
class Skb_Cife_Brands_Icon_Manager{

    private static $instance = null;

    public static function instance() {
        if ( is_null( self::$instance ) ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    function __construct(){
        $this->init();
    }

    public function init() {

        // Custom icon filter
        add_filter( 'elementor/icons_manager/additional_tabs', [ $this,'skb_cife_brands_icon'] );  

    }

	public function skb_cife_brands_icon( $brands_icons_args = array() ) {

	    // Append new icons
	    $brands_icons = array(
			'1password',
			'500px1',
			'abbrobotstudio',
			'about-dot-me',
			'abstract',
			'academia',
			'accusoft',
			'acm',
			'addthis',
			'adguard',
			'adobe',
			'adobeacrobatreader',
			'adobeaftereffects',
			'adobeaudition',
			'adobecreativecloud',
			'adobedreamweaver',
			'adobeillustrator',
			'adobeindesign',
			'adobelightroomcc',
			'adobelightroomclassic',
			'adobephotoshop',
			'adobepremiere',
			'adobetypekit',
			'adobexd',
			'airbnb',
			'airplayaudio',
			'airplayvideo',
			'algolia',
			'alliedmodders',
			'amazon1',
			'amazonalexa',
			'amazonaws',
			'amd',
			'americanexpress',
			'anaconda',
			'analogue',
			'anchor',
			'android1',
			'angellist',
			'angular',
			'angularuniversal',
			'ansible',
			'apache',
			'apacheairflow',
			'apachecordova',
			'apacheflink',
			'apachekafka',
			'apachenetbeanside',
			'apacheopenoffice',
			'apacherocketmq',
			'apachespark',
			'apple',
			'applemusic',
			'applepay',
			'applepodcasts',
			'appveyor',
			'aral',
			'archiveofourown',
			'archlinux',
			'arduino',
			'artstation',
			'arxiv',
			'asana',
			'asciidoctor',
			'at-and-t',
			'atlassian',
			'atom',
			'audi',
			'audible',
			'aurelia',
			'auth0',
			'automatic',
			'autotask',
			'aventrix',
			'awesomewm',
			'azureartifacts',
			'azuredevops',
			'azurepipelines',
			'babel',
			'baidu',
			'bamboo',
			'bancontact',
			'bandcamp',
			'bandlab',
			'basecamp1',
			'bathasu',
			'beats',
			'beatsbydre',
			'behance1',
			'bigcartel',
			'bing',
			'bit',
			'bitbucket',
			'bitcoin',
			'bitdefender',
			'bitly',
			'bitrise',
			'blackberry',
			'blender',
			'blogger1',
			'bmcsoftware',
			'boeing',
			'boost',
			'bootstrap',
			'bower',
			'box',
			'brand-dot-ai',
			'brandfolder',
			'brave',
			'breaker',
			'broadcom',
			'buddy',
			'buffer',
			'buymeacoffee',
			'buzzfeed',
			'c',
			'cakephp',
			'campaignmonitor',
			'canva',
			'cashapp',
			'cassandra',
			'castorama',
			'castro',
			'centos',
			'cevo',
			'chase',
			'chef',
			'circle',
			'circleci',
			'cirrusci',
			'cisco',
			'civicrm',
			'clockify',
			'clojure',
			'cloudbees',
			'cloudflare',
			'cmake',
			'co-op',
			'codacy',
			'codecademy',
			'codechef',
			'codeclimate',
			'codecov',
			'codefactor',
			'codeforces',
			'codeigniter',
			'codepen1',
			'coderwall',
			'codesandbox',
			'codeship',
			'codewars',
			'codio',
			'coffeescript',
			'coinbase',
			'commonworkflowlanguage',
			'composer',
			'compropago',
			'conda-forge',
			'conekta',
			'confluence',
			'coronarenderer',
			'coursera',
			'coveralls',
			'cpanel',
			'cplusplus',
			'creativecommons',
			'crehana',
			'crunchbase',
			'crunchyroll',
			'cryengine',
			'csharp',
			'css31',
			'csswizardry',
			'curl',
			'd3-dot-js',
			'dailymotion',
			'dart',
			'dashlane',
			'datacamp',
			'dazn',
			'dblp',
			'debian',
			'deepin',
			'deezer',
			'delicious1',
			'deliveroo',
			'dell',
			'deno',
			'dependabot',
			'designernews',
			'dev-dot-to',
			'deviantart1',
			'devrant',
			'diaspora',
			'digg',
			'digitalocean',
			'directus',
			'discord',
			'discourse',
			'discover',
			'disqus',
			'disroot',
			'django',
			'dlna',
			'docker',
			'docusign',
			'dolby',
			'dot-net',
			'draugiem-dot-lv',
			'dribbble1',
			'drone',
			'dropbox1',
			'drupal',
			'dtube',
			'duckduckgo',
			'dunked',
			'duolingo',
			'dynatrace',
			'ebay',
			'eclipseide',
			'elastic',
			'elasticcloud',
			'elasticsearch',
			'elasticstack',
			'electron',
			'elementary',
			'eleventy',
			'ello1',
			'elsevier',
			'ember-dot-js',
			'emlakjet',
			'empirekred',
			'envato',
			'epel',
			'epicgames',
			'epson',
			'esea',
			'eslint',
			'ethereum',
			'etsy',
			'eventbrite',
			'eventstore',
			'evernote',
			'everplaces',
			'evry',
			'exercism',
			'expertsexchange',
			'expo',
			'eyeem',
			'f-droid',
			'f-secure',
			'facebook1',
			'faceit',
			'fandango',
			'favro',
			'feathub',
			'fedora',
			'feedly',
			'fidoalliance',
			'figma',
			'filezilla',
			'firebase',
			'fitbit',
			'fiverr',
			'flask',
			'flattr1',
			'flickr1',
			'flipboard',
			'floatplane',
			'flutter',
			'fnac',
			'formstack',
			'fossa',
			'fossilscm',
			'foursquare1',
			'framer',
			'freebsd',
			'freecodecamp',
			'fujifilm',
			'fujitsu',
			'furaffinity',
			'furrynetwork',
			'garmin',
			'gatsby',
			'gauges',
			'genius',
			'gentoo',
			'geocaching',
			'gerrit',
			'ghost',
			'gimp',
			'git1',
			'gitea',
			'github1',
			'gitlab',
			'gitpod',
			'gitter',
			'glassdoor',
			'glitch',
			'gmail',
			'gnome',
			'gnu',
			'gnuicecat',
			'gnuprivacyguard',
			'gnusocial',
			'go',
			'godotengine',
			'gog-dot-com',
			'goldenline',
			'goodreads',
			'google1',
			'googleads',
			'googleanalytics',
			'googlechrome',
			'googlecloud',
			'googledrive',
			'googlehangouts',
			'googlehangoutschat',
			'googlekeep',
			'googlepay',
			'googleplay',
			'googlepodcasts',
			'googlescholar',
			'googlesearchconsole',
			'gov-dot-uk',
			'gradle',
			'grafana',
			'graphcool',
			'graphql',
			'grav',
			'gravatar',
			'greenkeeper',
			'greensock',
			'groovy',
			'groupon',
			'gulp',
			'gumroad',
			'gumtree',
			'gutenberg',
			'habr',
			'hackaday',
			'hackerearth',
			'hackerone',
			'hackerrank',
			'hackhands',
			'hackster',
			'happycow',
			'hashnode',
			'haskell',
			'hatenabookmark',
			'haxe',
			'helm',
			'here',
			'heroku',
			'hexo',
			'highly',
			'hipchat',
			'hitachi',
			'hockeyapp',
			'homeassistant',
			'homify',
			'hootsuite',
			'houzz',
			'hp',
			'html5',
			'htmlacademy',
			'huawei',
			'hubspot',
			'hulu',
			'humblebundle',
			'hurriyetemlak',
			'hypothesis',
			'iata',
			'ibm',
			'icloud',
			'icomoon',
			'icon',
			'iconjar',
			'icq',
			'ideal',
			'ifixit',
			'imdb',
			'imgur',
			'indeed',
			'influxdb',
			'inkscape',
			'instacart',
			'instagram1',
			'instapaper',
			'intel',
			'intellijidea',
			'intercom',
			'internetarchive',
			'internetexplorer',
			'invision',
			'invoiceninja',
			'ionic',
			'ios',
			'ipfs',
			'issuu',
			'itch-dot-io',
			'itunes',
			'jabber',
			'java',
			'javascript',
			'jekyll',
			'jenkins',
			'jest',
			'jet',
			'jetbrains',
			'jinja',
			'jira',
			'joomla1',
			'jquery',
			'jsdelivr',
			'jsfiddle',
			'json',
			'jupyter',
			'justgiving',
			'kaggle',
			'kaios',
			'kaspersky',
			'kentico',
			'keras',
			'keybase',
			'keycdn',
			'khanacademy',
			'kibana',
			'kickstarter',
			'kik',
			'kirby',
			'klout',
			'known',
			'ko-fi',
			'kodi',
			'koding',
			'kotlin',
			'krita',
			'kubernetes',
			'laravel',
			'laravelhorizon',
			'laravelnova',
			'last-dot-fm',
			'lastpass',
			'latex',
			'launchpad',
			'leetcode',
			'lenovo',
			'letsencrypt',
			'letterboxd',
			'lgtm',
			'liberapay',
			'librarything',
			'libreoffice1',
			'line',
			'linewebtoon',
			'linkedin1',
			'linode',
			'linux',
			'linuxfoundation',
			'linuxmint',
			'livejournal',
			'livestream',
			'llvm',
			'logstash',
			'loop1',
			'lua',
			'lufthansa',
			'lumen',
			'lyft',
			'macys',
			'magento',
			'magisk',
			'mail-dot-ru',
			'mailchimp',
			'makerbot',
			'manageiq',
			'manjaro',
			'mapbox',
			'markdown',
			'marketo',
			'mastercard',
			'mastodon',
			'materialdesign',
			'mathworks',
			'matrix',
			'mattermost',
			'matternet',
			'mcafee',
			'mdnwebdocs',
			'mediafire',
			'mediatemple',
			'medium',
			'meetup',
			'mega',
			'mendeley',
			'mercedes',
			'messenger',
			'meteor',
			'micro-dot-blog',
			'microgenetics',
			'microsoft',
			'microsoftaccess',
			'microsoftazure',
			'microsoftedge',
			'microsoftexcel',
			'microsoftoffice',
			'microsoftonedrive',
			'microsoftonenote',
			'microsoftoutlook',
			'microsoftpowerpoint',
			'microsoftteams',
			'microsoftword',
			'microstrategy',
			'minds',
			'minetest',
			'minutemailer',
			'mix',
			'mixcloud',
			'mixer',
			'mojang',
			'monero',
			'mongodb',
			'monkeytie',
			'monogram',
			'monster',
			'monzo',
			'moo',
			'mozilla',
			'mozillafirefox',
			'musescore',
			'mxlinux',
			'myspace',
			'mysql',
			'nativescript',
			'nec',
			'neo4j',
			'netflix',
			'netlify',
			'next-dot-js',
			'nextcloud',
			'nextdoor',
			'nginx',
			'nim',
			'nintendo',
			'nintendo3ds',
			'nintendogamecube',
			'nintendoswitch',
			'node-dot-js',
			'node-red',
			'nodemon',
			'nokia',
			'notion',
			'notist',
			'npm1',
			'nucleo',
			'nuget',
			'nutanix',
			'nuxt-dot-js',
			'nvidia',
			'obsstudio',
			'ocaml',
			'octave',
			'octopusdeploy',
			'oculus',
			'odnoklassniki',
			'openaccess',
			'openapiinitiative',
			'opencollective',
			'openid',
			'opensourceinitiative',
			'openssl',
			'openstreetmap',
			'opensuse',
			'openvpn',
			'opera1',
			'opsgenie',
			'oracle',
			'orcid',
			'origin',
			'osmc',
			'overcast',
			'overleaf',
			'ovh',
			'pagekit',
			'palantir',
			'paloaltosoftware',
			'pandora',
			'pantheon',
			'parse-dot-ly',
			'pastebin',
			'patreon',
			'paypal1',
			'peertube',
			'periscope',
			'php',
			'pi-hole',
			'picarto-dot-tv',
			'pinboard',
			'pingdom',
			'pingup',
			'pinterest1',
			'pivotaltracker',
			'pjsip',
			'plangrid',
			'player-dot-me',
			'playerfm',
			'playstation',
			'playstation3',
			'playstation4',
			'plesk',
			'plex',
			'pluralsight',
			'plurk',
			'pocket',
			'pocketcasts',
			'postgresql',
			'postman',
			'postwoman',
			'powershell',
			'prestashop',
			'prettier',
			'prismic',
			'probot',
			'processwire',
			'producthunt',
			'prometheus',
			'proto-dot-io',
			'protonmail',
			'proxmox',
			'publons',
			'purescript',
			'pypi',
			'python',
			'pytorch',
			'pyup',
			'qemu',
			'qgis',
			'qiita',
			'qualcomm',
			'quantcast',
			'quantopian',
			'quarkus',
			'quicktime',
			'quip',
			'quora',
			'qwiklabs',
			'qzone',
			'r',
			'rabbitmq',
			'radiopublic',
			'rails',
			'raspberrypi',
			'react',
			'reactos',
			'reactrouter',
			'readthedocs',
			'realm',
			'reason',
			'reasonstudios',
			'redbubble',
			'reddit1',
			'redhat',
			'redis',
			'redux',
			'renren1',
			'repl-dot-it',
			'researchgate',
			'reverbnation',
			'riot',
			'ripple',
			'riseup',
			'rollup-dot-js',
			'roots',
			'roundcube',
			'rss1',
			'rstudio',
			'ruby',
			'rubygems',
			'runkeeper',
			'rust',
			'safari1',
			'sahibinden',
			'salesforce',
			'saltstack',
			'samsung',
			'samsungpay',
			'sap',
			'sass',
			'saucelabs',
			'scala',
			'scaleway',
			'scribd',
			'scrutinizerci',
			'seagate',
			'sega',
			'sellfy',
			'semaphoreci',
			'sensu',
			'sentry',
			'serverfault',
			'shazam',
			'shell',
			'shopify',
			'showpad',
			'siemens',
			'signal',
			'simpleicons',
			'sinaweibo',
			'sitepoint',
			'sketch',
			'skillshare',
			'skyliner',
			'skype1',
			'slack',
			'slashdot',
			'slickpic',
			'slides',
			'smashingmagazine',
			'smugmug',
			'snapchat',
			'snapcraft',
			'snyk',
			'society6',
			'socket-dot-io',
			'sogou',
			'solus',
			'sonarcloud',
			'sonarlint',
			'sonarqube',
			'sonarsource',
			'songkick',
			'sonicwall',
			'sonos',
			'soundcloud1',
			'sourceengine',
			'sourceforge',
			'sourcegraph',
			'spacemacs',
			'spacex',
			'sparkfun',
			'sparkpost',
			'spdx',
			'speakerdeck',
			'spectrum',
			'spotify1',
			'spotlight',
			'spreaker',
			'spring',
			'sprint',
			'square',
			'squarespace',
			'stackbit',
			'stackexchange',
			'stackoverflow1',
			'stackpath',
			'stackshare',
			'stadia',
			'statamic',
			'staticman',
			'statuspage',
			'steam1',
			'steamworks',
			'steem',
			'steemit',
			'steinberg',
			'stencyl',
			'stitcher',
			'storify',
			'storybook',
			'strapi',
			'strava',
			'stripe',
			'strongswan',
			'stubhub',
			'styled-components',
			'styleshare',
			'stylus',
			'sublimetext',
			'subversion',
			'superuser',
			'svelte',
			'svg1',
			'svgo',
			'swagger',
			'swarm',
			'swift',
			'symantec',
			'symfony',
			'synology',
			't-mobile',
			'tableau',
			'tails',
			'tailwindcss',
			'tapas',
			'teamviewer',
			'ted',
			'teespring',
			'telegram1',
			'tencentqq',
			'tencentweibo',
			'tensorflow',
			'teradata',
			'terraform',
			'tesla',
			'themighty',
			'themoviedatabase',
			'tidal',
			'tiktok',
			'timescale',
			'tinder',
			'todoist',
			'toggl',
			'topcoder',
			'toptal',
			'tor',
			'toshiba',
			'trainerroad',
			'trakt',
			'travisci',
			'treehouse',
			'trello1',
			'trendmicro',
			'tripadvisor',
			'trulia',
			'trustpilot',
			'tumblr1',
			'turkishairlines',
			'twilio',
			'twitch1',
			'twitter1',
			'twoo',
			'typescript',
			'typo3',
			'uber',
			'ubereats',
			'ubisoft',
			'ublockorigin',
			'ubuntu',
			'udacity',
			'udemy',
			'uikit',
			'umbraco',
			'unity',
			'unrealengine',
			'unsplash',
			'untappd',
			'upwork',
			'v',
			'v8',
			'vagrant',
			'valve',
			'veeam',
			'venmo',
			'verizon',
			'viadeo',
			'viber',
			'vim',
			'vimeo1',
			'vine1',
			'virb',
			'visa',
			'visualstudio',
			'visualstudiocode',
			'vk1',
			'vlcmediaplayer',
			'vodafone',
			'volkswagen',
			'vsco',
			'vue-dot-js',
			'w3c',
			'wattpad',
			'waze',
			'weasyl',
			'webauthn',
			'webcomponents-dot-org',
			'webmin',
			'webpack',
			'webstorm',
			'wechat',
			'whatsapp1',
			'wheniwork',
			'whitesource',
			'wii',
			'wiiu',
			'wikipedia1',
			'windows1',
			'wire',
			'wireguard',
			'wish',
			'wix',
			'wolfram',
			'wolframlanguage',
			'wolframmathematica',
			'wordpress1',
			'workplace',
			'wpengine',
			'write-dot-as',
			'x-dot-org',
			'x-pack',
			'xamarin',
			'xbox',
			'xcode',
			'xdadevelopers',
			'xero',
			'xfce',
			'xiaomi',
			'xing1',
			'xmpp',
			'xrp',
			'xsplit',
			'yahoo1',
			'yamahacorporation',
			'yamahamotorcorporation',
			'yammer',
			'yandex',
			'yarn',
			'ycombinator',
			'yelp1',
			'youtube1',
			'zalando',
			'zapier',
			'zeit',
			'zend',
			'zendesk',
			'zendframework',
			'zeromq',
			'zerply',
			'zhihu',
			'zillow',
			'zingat',
			'zoom',
			'zorin',
			'zulip'

	    );
	    
	    $brands_icons_args['skb_cife-brands-icon'] = array(
	        'name'          => 'skb_cife-brands-icon',
	        'label'         => esc_html__( 'Skyboot:: Brands Icons', 'skb_cife' ),
	        'labelIcon'     => 'fa fa-user',
	        'prefix'        => 'icomoon_brands-',
	        'displayPrefix' => 'icomoon_brands',
	        'url'           => SKB_CIFE_ASSETS . 'css/icomoon_brands.css',
	        'icons'         => $brands_icons,
	        'ver'           => SKB_CIFE_VERSION,
	    );

	    return $brands_icons_args;
	}



}
Skb_Cife_Brands_Icon_Manager::instance();